<?php
// admin/delete_item.php
session_start();
require_once __DIR__ . '/../config/database.php';
require_once 'auth.php';

$auth = new AdminAuth();
if (!$auth->isLoggedIn()) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

if (!isset($_GET['id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Item ID required']);
    exit;
}

$db = new Database();
$conn = $db->getConnection();

$id = intval($_GET['id']);

try {
    // Get item info to delete image
    $stmt = $conn->prepare("SELECT image_url, outlet FROM menu_items WHERE id = ?");
    $stmt->execute([$id]);
    $item = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($item) {
        // Delete the item
        $delStmt = $conn->prepare("DELETE FROM menu_items WHERE id = ?");
        $delStmt->execute([$id]);
        
        // Delete image file if exists
        if (!empty($item['image_url'])) {
            $imagePath = __DIR__ . '/../images/' . $item['image_url'];
            if (file_exists($imagePath)) {
                unlink($imagePath);
            }
        }
        
        // Clear cache
        $outlet = $item['outlet'];
        $cacheFile = __DIR__ . "/../cache/menu_cache_{$outlet}.json";
        if (file_exists($cacheFile)) {
            unlink($cacheFile);
        }
        
        $pizzaCacheFile = __DIR__ . "/../cache/pizza_cache_{$outlet}.json";
        if (file_exists($pizzaCacheFile)) {
            unlink($pizzaCacheFile);
        }
        
        header('Content-Type: application/json');
        echo json_encode(['success' => true, 'message' => 'Item deleted successfully']);
    } else {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => 'Item not found']);
    }
    
} catch (Exception $e) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Error deleting item: ' . $e->getMessage()]);
}
?>