<?php
// Turn on ALL error reporting at the VERY TOP
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

echo "=== DEBUG MODE START ===<br>";

// Start session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
echo "1. Session started: " . session_id() . "<br>";

$username = 'admin';
$password = 'Kaka3r@za';

echo "2. Testing with username: $username<br>";

try {
    echo "3. Loading database.php... ";
    require_once '../config/database.php';
    echo "✅ LOADED<br>";
    
    echo "4. Creating Database object... ";
    $database = new Database();
    echo "✅ CREATED<br>";
    
    echo "5. Getting connection... ";
    $conn = $database->getConnection();
    echo "✅ CONNECTED<br>";
    
    // Test the exact query from auth.php
    echo "6. Running auth.php query...<br>";
    $sql = "SELECT * FROM admin_users WHERE username = :username AND status = 'active'";
    echo "   SQL: $sql<br>";
    
    $stmt = $conn->prepare($sql);
    $stmt->execute([':username' => $username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($user) {
        echo "   ✅ User found!<br>";
        echo "   Username: " . $user['username'] . "<br>";
        echo "   Status: " . $user['status'] . "<br>";
        echo "   Name: " . $user['name'] . "<br>";
        echo "   Role: " . $user['role'] . "<br>";
        
        echo "<br>7. Testing password verification...<br>";
        echo "   Password to test: $password<br>";
        echo "   Hash in DB: " . substr($user['password'], 0, 30) . "...<br>";
        
        if (password_verify($password, $user['password'])) {
            echo "   ✅ Password verification PASSED!<br>";
            
            // Now test auth.php
            echo "<br>8. Loading auth.php... ";
            require_once 'auth.php';
            echo "✅ LOADED<br>";
            
            echo "9. Creating AdminAuth object... ";
            $auth = new AdminAuth();
            echo "✅ CREATED<br>";
            
            echo "10. Calling login() method...<br>";
            $result = $auth->login($username, $password);
            
            if ($result) {
                echo "   ✅ login() returned TRUE!<br>";
                echo "<br>SESSION VARIABLES:<br>";
                echo "- admin_id: " . ($_SESSION['admin_id'] ?? 'NOT SET') . "<br>";
                echo "- admin_username: " . ($_SESSION['admin_username'] ?? 'NOT SET') . "<br>";
                echo "- admin_role: " . ($_SESSION['admin_role'] ?? 'NOT SET') . "<br>";
                echo "- admin_name: " . ($_SESSION['admin_name'] ?? 'NOT SET') . "<br>";
                
                echo "<br><a href='index.php' style='color: green; font-weight: bold;'>GO TO DASHBOARD</a>";
            } else {
                echo "   ❌ login() returned FALSE!<br>";
                
                // Debug why
                echo "<br>Debugging why login() failed...<br>";
                echo "Checking session after failed login:<br>";
                echo "Session ID: " . session_id() . "<br>";
                echo "Session data: ";
                print_r($_SESSION);
            }
            
        } else {
            echo "   ❌ Password verification FAILED!<br>";
            echo "   This means the password 'Kaka3r@za' doesn't match the hash.<br>";
            echo "   Try: 'admin123', 'password', '123456'<br>";
        }
        
    } else {
        echo "   ❌ User NOT FOUND or status not 'active'!<br>";
        
        // Check without status condition
        $stmt = $conn->prepare("SELECT * FROM admin_users WHERE username = :username");
        $stmt->execute([':username' => $username]);
        $any_user = $stmt->fetch();
        
        if ($any_user) {
            echo "   ⚠️ User exists but status is: " . ($any_user['status'] ?? 'unknown') . "<br>";
            echo "   Change status to 'active' with this SQL:<br>";
            echo "   <code>UPDATE admin_users SET status = 'active' WHERE username = 'admin'</code><br>";
        } else {
            echo "   ⚠️ User doesn't exist at all!<br>";
        }
    }
    
} catch (Exception $e) {
    echo "<br>❌ EXCEPTION: " . $e->getMessage() . "<br>";
    echo "File: " . $e->getFile() . " Line: " . $e->getLine() . "<br>";
    echo "Trace: " . $e->getTraceAsString() . "<br>";
}

echo "<br>=== DEBUG MODE END ===";
?>