<?php
// test_live_stk.php — Send a real 1-KES STK push without creating an order
// Usage:
// https://aromacafe.co.ke/blaqpremium/mpesa/test_live_stk.php?phone=2547XXXXXXX

require_once __DIR__ . '/../config/mpesa_config.php';

// 1. Read phone number
$phone = isset($_GET['phone']) ? trim($_GET['phone']) : '';

if (!$phone) {
    echo json_encode([
        "success" => false,
        "message" => "Please provide phone in format: ?phone=2547XXXXXXXX"
    ], JSON_PRETTY_PRINT);
    exit;
}

// Format phone number
$phone = preg_replace('/\D/', '', $phone);

if (strlen($phone) == 10 && substr($phone, 0, 2) === "07") {
    $phone = "254" . substr($phone, 1);
} elseif (strlen($phone) == 9 && $phone[0] == '7') {
    $phone = "254" . $phone;
}

if (strlen($phone) !== 12) {
    echo json_encode([
        "success" => false,
        "message" => "Invalid phone format. Use 2547XXXXXXXX"
    ], JSON_PRETTY_PRINT);
    exit;
}

// 2. Get MPESA access token
$credentials = base64_encode(MpesaConfig::CONSUMER_KEY . ':' . MpesaConfig::CONSUMER_SECRET);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, MpesaConfig::OAUTH_URL);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Authorization: Basic $credentials"
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);

$tokenResponse = curl_exec($ch);
$tokenError = curl_error($ch);
curl_close($ch);

if ($tokenError) {
    echo json_encode([
        "success" => false,
        "message" => "Network error getting token: $tokenError"
    ]);
    exit;
}

$tokenData = json_decode($tokenResponse, true);

if (!isset($tokenData['access_token'])) {
    echo json_encode([
        "success" => false,
        "message" => "Failed to get access token",
        "response" => $tokenResponse
    ]);
    exit;
}

$access_token = $tokenData['access_token'];

// 3. Build STK Payload for KES 1 test
$passwordData = MpesaConfig::generatePassword();

$payload = [
    "BusinessShortCode" => MpesaConfig::BUSINESS_SHORT_CODE,
    "Password" => $passwordData['password'],
    "Timestamp" => $passwordData['timestamp'],
    "TransactionType" => "CustomerPayBillOnline",
    "Amount" => 1, // ALWAYS 1 KES
    "PartyA" => $phone,
    "PartyB" => MpesaConfig::BUSINESS_SHORT_CODE,
    "PhoneNumber" => $phone,
    "CallBackURL" => MpesaConfig::CALLBACK_URL,
    "AccountReference" => "TEST-1-KES",
    "TransactionDesc" => "1 KES STK LIVE TEST"
];

// 4. Send STK Push
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, MpesaConfig::STK_PUSH_URL);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Authorization: Bearer $access_token",
    "Content-Type: application/json"
]);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);

$response = curl_exec($ch);
$curlErr = curl_error($ch);
curl_close($ch);

if ($curlErr) {
    echo json_encode([
        "success" => false,
        "message" => "STK network error: $curlErr"
    ]);
    exit;
}

$decoded = json_decode($response, true);

// 5. Final output
if (isset($decoded['ResponseCode']) && $decoded['ResponseCode'] == "0") {
    echo json_encode([
        "success" => true,
        "message" => "STK push sent successfully! Check your phone.",
        "checkout_id" => $decoded['CheckoutRequestID'],
        "merchant_request_id" => $decoded['MerchantRequestID'],
        "raw" => $response
    ], JSON_PRETTY_PRINT);
} else {
    echo json_encode([
        "success" => false,
        "message" => "STK failed",
        "raw" => $response
    ], JSON_PRETTY_PRINT);
}
?>
