<?php
// test_setup.php - Located at https://aromacafe.co.ke/blaqpremium/test_setup.php

echo "<h1>BLAQ PREMIUM - Setup Test</h1>";
echo "<p>Testing from: " . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'] . "</p>";

// Test 1: Database Connection
echo "<h2>Test 1: Database Connection</h2>";
require_once 'config/database.php';
$db = new Database();
$conn = $db->getConnection();

if ($conn) {
    echo "✓ Database connection successful<br>";
    
    // Test if tables exist
    $tables = ['orders', 'order_items', 'mpesa_transactions', 'admin_users'];
    foreach ($tables as $table) {
        try {
            $stmt = $conn->query("SHOW TABLES LIKE '$table'");
            if ($stmt->rowCount() > 0) {
                echo "✓ Table '$table' exists<br>";
            } else {
                echo "✗ Table '$table' NOT found<br>";
            }
        } catch (Exception $e) {
            echo "✗ Error checking table '$table': " . $e->getMessage() . "<br>";
        }
    }
} else {
    echo "✗ Database connection failed<br>";
}

// Test 2: M-Pesa Configuration
echo "<h2>Test 2: M-Pesa Configuration</h2>";
require_once 'config/mpesa_config.php';

echo "Consumer Key: " . (strlen(MpesaConfig::CONSUMER_KEY) > 10 ? "✓ Set" : "✗ Missing") . "<br>";
echo "Business Short Code: " . MpesaConfig::BUSINESS_SHORT_CODE . "<br>";
echo "Callback URL: " . MpesaConfig::getCallbackUrl() . "<br>";

// Test callback URL
$testUrl = MpesaConfig::getCallbackUrl();
echo "Testing callback URL: $testUrl<br>";

$ch = curl_init($testUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode == 200) {
    echo "✓ Callback URL accessible (HTTP $httpCode)<br>";
} else {
    echo "✗ Callback URL not accessible (HTTP $httpCode)<br>";
}

// Test 3: Directory Structure
echo "<h2>Test 3: Directory Structure</h2>";
$dirs = ['config', 'includes', 'mpesa', 'logs'];
foreach ($dirs as $dir) {
    if (is_dir($dir)) {
        echo "✓ Directory '$dir' exists<br>";
    } else {
        echo "✗ Directory '$dir' not found<br>";
    }
}

// Test 4: PHP Extensions
echo "<h2>Test 4: PHP Extensions</h2>";
$extensions = ['pdo_mysql', 'curl', 'json', 'openssl'];
foreach ($extensions as $ext) {
    if (extension_loaded($ext)) {
        echo "✓ Extension '$ext' loaded<br>";
    } else {
        echo "✗ Extension '$ext' NOT loaded<br>";
    }
}

// Test 5: File Permissions
echo "<h2>Test 5: File Permissions</h2>";
$files = ['config/database.php', 'config/mpesa_config.php', 'includes/MpesaService.php', 
          'process_order.php', 'check_payment_status.php', 'mpesa/callback.php'];
foreach ($files as $file) {
    if (file_exists($file)) {
        $perms = substr(sprintf('%o', fileperms($file)), -4);
        echo "✓ $file exists (perms: $perms)<br>";
    } else {
        echo "✗ $file not found<br>";
    }
}

echo "<hr><h2>Next Steps:</h2>";
echo "1. Test with cash on delivery first<br>";
echo "2. Then test M-Pesa with KSh 1<br>";
echo "3. Check logs in /blaqpremium/logs/ directory<br>";
echo "4. Monitor database entries<br>";

// Quick database test
if ($conn) {
    echo "<h2>Quick Database Test:</h2>";
    try {
        // Try to insert a test order
        $testQuery = "INSERT INTO orders (order_number, customer_name, customer_phone, customer_address, payment_method, total_amount, status) 
                      VALUES ('TEST-001', 'Test Customer', '254712345678', 'Test Address', 'cash', 100.00, 'pending')";
        if ($conn->exec($testQuery)) {
            echo "✓ Test order inserted successfully<br>";
            
            // Clean up
            $conn->exec("DELETE FROM orders WHERE order_number = 'TEST-001'");
            echo "✓ Test order cleaned up<br>";
        }
    } catch (Exception $e) {
        echo "✗ Database test failed: " . $e->getMessage() . "<br>";
    }
}
?>