<?php
// Turn on all errors
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h3>Login Debug Test</h3>";

// Test 1: Check if session works
echo "1. Testing session... ";
session_start();
echo "OK<br>";

// Test 2: Check if database.php exists
echo "2. Checking database.php... ";
$db_file = dirname(__DIR__) . '/config/database.php';
if (file_exists($db_file)) {
    echo "EXISTS<br>";
} else {
    echo "NOT FOUND at: $db_file<br>";
    exit;
}

// Test 3: Try to load database.php
echo "3. Loading database.php... ";
try {
    require_once $db_file;
    echo "LOADED<br>";
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "<br>";
    exit;
}

// Test 4: Try to create Database object
echo "4. Creating Database object... ";
try {
    $database = new Database();
    echo "CREATED<br>";
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "<br>";
    exit;
}

// Test 5: Try to get connection
echo "5. Getting database connection... ";
try {
    $conn = $database->getConnection();
    echo "CONNECTED<br>";
    
    // Check what database we're connected to
    $db_name = $conn->query("SELECT DATABASE()")->fetchColumn();
    echo "   Connected to database: $db_name<br>";
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "<br>";
    exit;
}

// Test 6: Check if auth.php exists
echo "6. Checking auth.php... ";
$auth_file = __DIR__ . '/auth.php';
if (file_exists($auth_file)) {
    echo "EXISTS<br>";
} else {
    echo "NOT FOUND at: $auth_file<br>";
    exit;
}

// Test 7: Try to load auth.php
echo "7. Loading auth.php... ";
try {
    require_once $auth_file;
    echo "LOADED<br>";
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "<br>";
    exit;
}

// Test 8: Try to create AdminAuth object
echo "8. Creating AdminAuth object... ";
try {
    $auth = new AdminAuth();
    echo "CREATED<br>";
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "<br>";
    exit;
}

echo "<br><strong>✅ All tests passed! Login should work.</strong><br>";
?>