<?php
// Final comprehensive test
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Clear any existing session
session_start();
session_destroy();

// Start fresh
session_start();

echo "<h3>Final Login Test</h3>";

// Step 1: Direct database test
require_once '../config/database.php';
$database = new Database();
$conn = $database->getConnection();

$username = 'admin';
$password = 'Admin123!';

echo "1. Database check: ";
$stmt = $conn->prepare("SELECT * FROM admin_users WHERE username = :username AND status = 'active'");
$stmt->execute([':username' => $username]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if ($user) {
    echo "✅ User exists and is active<br>";
    echo "   Status: " . $user['status'] . "<br>";
} else {
    echo "❌ User not found or inactive<br>";
    exit;
}

echo "<br>2. Password verification: ";
if (password_verify($password, $user['password'])) {
    echo "✅ Password correct!<br>";
} else {
    echo "❌ Password wrong!<br>";
    exit;
}

echo "<br>3. Testing auth.php: ";
require_once 'auth.php';
try {
    $auth = new AdminAuth();
    echo "✅ AdminAuth loaded<br>";
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "<br>";
    exit;
}

echo "<br>4. Calling login() method: ";
if ($auth->login($username, $password)) {
    echo "✅ LOGIN SUCCESS!<br><br>";
    
    echo "<strong>Session Data:</strong><br>";
    echo "- admin_id: " . $_SESSION['admin_id'] . "<br>";
    echo "- admin_username: " . $_SESSION['admin_username'] . "<br>";
    echo "- admin_role: " . $_SESSION['admin_role'] . "<br>";
    echo "- admin_name: " . $_SESSION['admin_name'] . "<br>";
    
    echo "<br><a href='index.php' style='background: green; color: white; padding: 15px; font-size: 18px; text-decoration: none;'>🚀 GO TO DASHBOARD</a>";
    
} else {
    echo "❌ LOGIN FAILED<br>";
    
    // Last resort - manual login
    echo "<br><strong>Manual Login:</strong><br>";
    $_SESSION['admin_id'] = $user['id'];
    $_SESSION['admin_username'] = $user['username'];
    $_SESSION['admin_role'] = $user['role'];
    $_SESSION['admin_name'] = $user['name'];
    
    echo "Session manually set!<br>";
    echo "<a href='index.php'>Try dashboard now</a>";
}
?>