<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once '../config/database.php';

$database = new Database();
$conn = $database->getConnection();

// Set a SIMPLE password that you'll remember
$new_password = 'Admin123!'; // Change this if you want
$new_hash = password_hash($new_password, PASSWORD_DEFAULT);

echo "Resetting password for 'admin' user...<br>";

$stmt = $conn->prepare("UPDATE admin_users SET password = :password WHERE username = 'admin'");
$stmt->execute([':password' => $new_hash]);

echo "✅ PASSWORD RESET!<br><br>";
echo "============================================<br>";
echo "USE THESE EXACT CREDENTIALS:<br>";
echo "============================================<br>";
echo "Username: <strong style='font-size: 20px;'>admin</strong><br>";
echo "Password: <strong style='font-size: 20px; color: green;'>$new_password</strong><br>";
echo "============================================<br><br>";

// Verify it worked
$stmt = $conn->prepare("SELECT username, LEFT(password, 30) as hash_start FROM admin_users WHERE username = 'admin'");
$stmt->execute();
$result = $stmt->fetch();

echo "Verification:<br>";
echo "Username: " . $result['username'] . "<br>";
echo "Hash starts with: " . $result['hash_start'] . "...<br><br>";

// Test password verification
if (password_verify($new_password, $new_hash)) {
    echo "✅ Password verification test PASSED!<br>";
} else {
    echo "❌ Password verification test FAILED (this shouldn't happen)<br>";
}

echo "<br><a href='login.php' style='background: green; color: white; padding: 15px 30px; text-decoration: none; font-size: 18px; font-weight: bold; display: inline-block; margin: 20px 0;'>➡️ CLICK HERE TO GO TO LOGIN PAGE</a>";
?>