<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h3>Setting up Admin System</h3>";

// Database credentials directly (from your database.php)
$host = "localhost";
$dbname = "cafearoma_blaqweb";
$username = "cafearoma_blaqweb";
$password = "F9V*Q)z}p1~f=oBt";

try {
    // Connect to database
    $conn = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "✅ Connected to database: $dbname<br><br>";
    
    // 1. Create admin_users table
    echo "1. Creating admin_users table... ";
    $sql = "CREATE TABLE IF NOT EXISTS admin_users (
        id INT(11) AUTO_INCREMENT PRIMARY KEY,
        username VARCHAR(50) UNIQUE NOT NULL,
        password VARCHAR(255) NOT NULL,
        name VARCHAR(100) NOT NULL,
        role ENUM('superadmin', 'admin', 'manager', 'staff') DEFAULT 'staff',
        status ENUM('active', 'inactive', 'suspended') DEFAULT 'active',
        last_login DATETIME NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    
    $conn->exec($sql);
    echo "✅ Done<br>";
    
    // 2. Create admin_activity_log table
    echo "2. Creating admin_activity_log table... ";
    $sql = "CREATE TABLE IF NOT EXISTS admin_activity_log (
        id INT(11) AUTO_INCREMENT PRIMARY KEY,
        admin_id INT(11) NOT NULL,
        action VARCHAR(50) NOT NULL,
        description TEXT,
        ip_address VARCHAR(45),
        user_agent TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        INDEX idx_admin_id (admin_id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    
    $conn->exec($sql);
    echo "✅ Done<br><br>";
    
    // 3. Check if admin exists
    echo "3. Checking for existing admin... ";
    $stmt = $conn->prepare("SELECT id FROM admin_users WHERE username = 'admin'");
    $stmt->execute();
    
    if ($stmt->rowCount() > 0) {
        echo "✅ Admin user already exists<br>";
    } else {
        // 4. Create admin user
        echo "❌ No admin found, creating one... ";
        $password_hash = password_hash('admin123', PASSWORD_DEFAULT);
        
        $sql = "INSERT INTO admin_users (username, password, name, role, status) 
                VALUES ('admin', :password, 'Administrator', 'superadmin', 'active')";
        
        $stmt = $conn->prepare($sql);
        $stmt->execute([':password' => $password_hash]);
        echo "✅ Admin created<br>";
    }
    
    echo "<br><h4>✅ Setup Complete!</h4>";
    echo "<strong>Login Credentials:</strong><br>";
    echo "Username: admin<br>";
    echo "Password: admin123<br><br>";
    echo "<em>Change this password immediately after first login!</em>";
    
} catch (PDOException $e) {
    echo "❌ Database Error: " . $e->getMessage() . "<br>";
    echo "Error Code: " . $e->getCode() . "<br>";
}
?>