<?php
// config/database.php

class Database {
    private $host = "localhost";
    private $db_name = "cafearoma_blaqweb";
    private $username = "cafearoma_blaqweb";
    private $password = "F9V*Q)z}p1~f=oBt";
    private $conn;

    public function getConnection() {
        $this->conn = null;
        
        try {
            $this->conn = new PDO(
                "mysql:host=" . $this->host . ";dbname=" . $this->db_name . ";charset=utf8mb4",
                $this->username,
                $this->password
            );
            $this->conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $this->conn->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
            
        } catch(PDOException $exception) {
            error_log("Connection error: " . $exception->getMessage());
            throw new Exception("Database connection failed");
        }
        
        return $this->conn;
    }
    
    // Create tables matching your callback structure
    public function createTables() {
        try {
            $conn = $this->getConnection();
            
            // 1. Admin users table (MUST COME FIRST for foreign keys)
            $sql = "CREATE TABLE IF NOT EXISTS admin_users (
                id INT(11) AUTO_INCREMENT PRIMARY KEY,
                username VARCHAR(50) UNIQUE NOT NULL,
                password VARCHAR(255) NOT NULL,
                name VARCHAR(100) NOT NULL,
                role ENUM('superadmin', 'admin', 'manager', 'staff') DEFAULT 'staff',
                status ENUM('active', 'inactive', 'suspended') DEFAULT 'active',
                last_login DATETIME NULL,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                
                INDEX idx_username (username),
                INDEX idx_status (status)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
            
            $conn->exec($sql);
            
            // 2. Admin activity log table
            $sql = "CREATE TABLE IF NOT EXISTS admin_activity_log (
                id INT(11) AUTO_INCREMENT PRIMARY KEY,
                admin_id INT(11) NOT NULL,
                action VARCHAR(50) NOT NULL,
                description TEXT,
                ip_address VARCHAR(45),
                user_agent TEXT,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                
                FOREIGN KEY (admin_id) REFERENCES admin_users(id) ON DELETE CASCADE,
                INDEX idx_admin_id (admin_id),
                INDEX idx_created_at (created_at)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
            
            $conn->exec($sql);
            
            // 3. Orders table (matches your callback fields)
            $sql = "CREATE TABLE IF NOT EXISTS orders (
                id INT(11) AUTO_INCREMENT PRIMARY KEY,
                order_number VARCHAR(50) UNIQUE NOT NULL,
                customer_name VARCHAR(100) NOT NULL,
                customer_phone VARCHAR(20) NOT NULL,
                customer_address TEXT NOT NULL,
                delivery_location VARCHAR(100) NOT NULL,
                delivery_fee DECIMAL(10,2) DEFAULT 0,
                payment_method ENUM('mpesa', 'cash') DEFAULT 'mpesa',
                total_amount DECIMAL(10,2) NOT NULL,
                status ENUM('pending', 'paid', 'processing', 'completed', 'cancelled', 'failed') DEFAULT 'pending',
                
                -- M-Pesa fields (matching your callback)
                mpesa_checkout_id VARCHAR(100),
                mpesa_receipt VARCHAR(100),
                mpesa_transaction_date DATETIME,
                payment_notes TEXT,
                
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                
                INDEX idx_status (status),
                INDEX idx_mpesa_checkout (mpesa_checkout_id),
                INDEX idx_order_number (order_number)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
            
            $conn->exec($sql);
            
            // 4. Order items table
            $sql = "CREATE TABLE IF NOT EXISTS order_items (
                id INT(11) AUTO_INCREMENT PRIMARY KEY,
                order_id INT(11) NOT NULL,
                item_name VARCHAR(100) NOT NULL,
                item_price DECIMAL(10,2) NOT NULL,
                quantity INT(11) NOT NULL,
                subtotal DECIMAL(10,2) NOT NULL,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                
                FOREIGN KEY (order_id) REFERENCES orders(id) ON DELETE CASCADE,
                INDEX idx_order_id (order_id)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
            
            $conn->exec($sql);
            
            // 5. M-Pesa transactions table (matching your callback)
            $sql = "CREATE TABLE IF NOT EXISTS mpesa_transactions (
                id INT(11) AUTO_INCREMENT PRIMARY KEY,
                checkout_request_id VARCHAR(100),
                merchant_request_id VARCHAR(100),
                result_code VARCHAR(10),
                result_desc VARCHAR(255),
                amount DECIMAL(10,2),
                mpesa_receipt_number VARCHAR(100),
                transaction_date VARCHAR(50),
                phone_number VARCHAR(20),
                status ENUM('pending', 'success', 'failed') DEFAULT 'pending',
                raw_callback TEXT,
                order_id INT(11),
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                
                INDEX idx_checkout_id (checkout_request_id),
                INDEX idx_status (status),
                INDEX idx_order_id (order_id)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
            
            $conn->exec($sql);
            
            // Create logs directory
            if (!is_dir(__DIR__ . '/../logs')) {
                mkdir(__DIR__ . '/../logs', 0755, true);
            }
            
        } catch (Exception $e) {
            error_log("Table creation error: " . $e->getMessage());
        }
    }
}

// REMOVE OR COMMENT OUT THESE LINES - they cause the parse error!
// // Initialize database and create tables
// $database = new Database();
// $database->createTables();
?>