<?php
// order_success.php

require_once __DIR__ . '/config/database.php';

$order_id = $_GET['order_id'] ?? null;
$order_number = $_GET['order_number'] ?? null;

// If no order ID provided, redirect to homepage
if (!$order_id && !$order_number) {
    header('Location: index.php');
    exit;
}

try {
    $database = new Database();
    $conn = $database->getConnection();
    
    // Fetch order details
    $sql = "SELECT * FROM orders WHERE ";
    $params = [];
    
    if ($order_id) {
        $sql .= "id = :id";
        $params[':id'] = $order_id;
    } else {
        $sql .= "order_number = :order_number";
        $params[':order_number'] = $order_number;
    }
    
    $stmt = $conn->prepare($sql);
    $stmt->execute($params);
    $order = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$order) {
        header('Location: index.php');
        exit;
    }
    
    // Fetch order items
    $sql = "SELECT * FROM order_items WHERE order_id = :order_id ORDER BY id";
    $stmt = $conn->prepare($sql);
    $stmt->execute([':order_id' => $order['id']]);
    $items = $stmt->fetchAll();
    
} catch (Exception $e) {
    // If there's an error, still show success page but without details
    $order = ['order_number' => $order_number ?? 'N/A'];
    $items = [];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Confirmed - SUSHI-BAR</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #e53935;
            --secondary: #25D366;
            --success: #2e7d32;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            margin: 0;
        }
        
        .success-container {
            background: white;
            border-radius: 15px;
            padding: 40px;
            max-width: 600px;
            width: 100%;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            text-align: center;
            animation: fadeIn 0.5s ease-out;
        }
        
        .success-icon {
            font-size: 80px;
            color: var(--success);
            margin-bottom: 20px;
            animation: bounce 1s ease infinite alternate;
        }
        
        .order-number {
            background: linear-gradient(to right, var(--primary), #ff6b6b);
            color: white;
            padding: 10px 20px;
            border-radius: 30px;
            font-size: 1.5rem;
            font-weight: bold;
            display: inline-block;
            margin: 20px 0;
        }
        
        .order-details {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 25px;
            margin: 25px 0;
            text-align: left;
        }
        
        .detail-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px dashed #dee2e6;
        }
        
        .detail-row:last-child {
            border-bottom: none;
            font-weight: bold;
            font-size: 1.2rem;
            color: var(--primary);
        }
        
        .whatsapp-contact {
            background: var(--secondary);
            color: white;
            padding: 15px 30px;
            border-radius: 30px;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 10px;
            font-weight: 600;
            margin: 20px 0;
            transition: transform 0.3s;
        }
        
        .whatsapp-contact:hover {
            transform: translateY(-2px);
        }
        
        .action-buttons {
            display: flex;
            gap: 15px;
            justify-content: center;
            margin-top: 30px;
        }
        
        .btn {
            padding: 12px 30px;
            border-radius: 30px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s;
            border: none;
            cursor: pointer;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }
        
        .btn-primary {
            background: var(--primary);
            color: white;
        }
        
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        @keyframes bounce {
            from { transform: translateY(0); }
            to { transform: translateY(-10px); }
        }
        
        @media (max-width: 768px) {
            .success-container {
                padding: 25px;
            }
            
            .action-buttons {
                flex-direction: column;
            }
            
            .btn {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <div class="success-container">
        <div class="success-icon">
            <i class="fas fa-check-circle"></i>
        </div>
        
        <h1>Order Confirmed!</h1>
        <p>Thank you for your order from SUSHI-BAR</p>
        
        <div class="order-number">
            <?php echo htmlspecialchars($order['order_number']); ?>
        </div>
        
        <?php if ($order): ?>
        <div class="order-details">
            <div class="detail-row">
                <span>Customer Name:</span>
                <span><?php echo htmlspecialchars($order['customer_name']); ?></span>
            </div>
            <div class="detail-row">
                <span>Delivery To:</span>
                <span><?php echo htmlspecialchars($order['delivery_location']); ?></span>
            </div>
            <div class="detail-row">
                <span>Delivery Fee:</span>
                <span>KES <?php echo number_format($order['delivery_fee'], 2); ?></span>
            </div>
            <div class="detail-row">
                <span>Payment Method:</span>
                <span><?php echo strtoupper($order['payment_method']); ?></span>
            </div>
            <div class="detail-row">
                <span>Order Total:</span>
                <span>KES <?php echo number_format($order['total_amount'], 2); ?></span>
            </div>
        </div>
        
        <?php if ($order['payment_method'] === 'cash'): ?>
        <div style="background: #e8f5e9; padding: 15px; border-radius: 10px; margin: 20px 0;">
            <i class="fas fa-money-bill-wave"></i>
            <strong>Cash Payment</strong>
            <p>Please have KES <?php echo number_format($order['total_amount'], 2); ?> ready for cash payment on delivery.</p>
        </div>
        <?php endif; ?>
        <?php endif; ?>
        
        <a href="https://wa.me/254790644644?text=Hello%20SUSHI-BAR%2C%20I%20just%20placed%20order%20<?php echo urlencode($order['order_number'] ?? ''); ?>%20and%20have%20a%20question" 
           target="_blank" 
           class="whatsapp-contact">
            <i class="fab fa-whatsapp"></i> Contact us on WhatsApp
        </a>
        
        <div class="action-buttons">
            <a href="index.php" class="btn btn-primary">
                <i class="fas fa-home"></i> Back to Home
            </a>
            <button onclick="window.print()" class="btn btn-secondary">
                <i class="fas fa-print"></i> Print Receipt
            </button>
        </div>
        
        <p style="margin-top: 30px; color: #666; font-size: 0.9rem;">
            <i class="fas fa-clock"></i> Your order will be delivered within 30-45 minutes
        </p>
    </div>
    
    <script>
        // Optional: Auto-print option
        const urlParams = new URLSearchParams(window.location.search);
        if (urlParams.get('print') === 'true') {
            window.print();
        }
        
        // Store order in localStorage to clear cart
        localStorage.removeItem('sushi_bar_cart');
    </script>
</body>
</html>