<?php
// test_connection.php – Test Safaricom Production API connectivity

require_once __DIR__ . '/config/mpesa_config.php';

header("Content-Type: application/json");

// Step 1: Prepare credentials
$credentials = base64_encode(
    MpesaConfig::CONSUMER_KEY . ':' . MpesaConfig::CONSUMER_SECRET
);

// Step 2: Initialize cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, MpesaConfig::OAUTH_URL);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Basic ' . $credentials
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);   // Required in production
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 20);

// Step 3: Execute
$response = curl_exec($ch);
$err      = curl_error($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Step 4: Decode Safaricom response
$decoded = json_decode($response, true);

// Step 5: Build result output
$result = [
    'success'      => false,
    'http_code'    => $httpCode,
    'error'        => $err ?: null,
    'raw_response' => $response
];

// Step 6: Determine successful connectivity
if ($err) {
    $result['message'] = 'cURL communication failure (network/server)';
    echo json_encode($result, JSON_PRETTY_PRINT);
    exit;
}

if ($httpCode === 200 && isset($decoded['access_token'])) {
    $result['success']  = true;
    $result['message']  = '✔ Safaricom Production API reachable and token retrieved successfully!';
    echo json_encode($result, JSON_PRETTY_PRINT);
    exit;
}

$result['message'] = '❌ API reachable but credentials or SSL validation failed.';
echo json_encode($result, JSON_PRETTY_PRINT);
